(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel'], function(Backbone, Moment, RequestModel) {
    var ContactModel;
    return ContactModel = class ContactModel extends Backbone.Model {
      initialize() {
        //console.log "Model ContactModel initialized"
        return this.reqMdl = new RequestModel();
      }

      get_details_contact(sessionID, contactID) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetContact');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'contactID', contactID);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      get_details_contact_from_customfield(sessionID, value) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetContact');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'findFromCustomFieldValue', value);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      get_details_company(sessionID, companyID, includeContacts = true) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetCompany');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'companyID', companyID);
        if (!includeContacts) {
          this.reqMdl.__setNodeValue(jsonReq, 'includeContacts', "0");
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
            return that.trigger('companyFilled');
          }
        });
        return this;
      }

      save_contact(sessionID, contactObject) {
        var jsonReq, parent, response, that, xmlReq;
        that = this;
        parent = 'Contact';
        jsonReq = this.reqMdl.get('JCommitContact');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'contactID', contactObject.contactID);
        if (contactObject.firstName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'firstName', contactObject.firstName);
        }
        if (contactObject.lastName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'lastName', contactObject.lastName);
        }
        if (contactObject.type) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'type', contactObject.type);
        }
        if (contactObject.title) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'title', contactObject.title);
        }
        if (contactObject.email) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'email', contactObject.email);
        }
        if (contactObject.www) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'www', contactObject.www);
        }
        if (contactObject.category) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'category', contactObject.category);
        }
        if (contactObject.companyName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'companyName', contactObject.companyName);
        }
        if (contactObject.companyID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'companyID', contactObject.companyID);
        }
        if (contactObject.address) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'address', contactObject.address);
        }
        if (contactObject.phoneHome) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'phoneHome', contactObject.phoneHome);
        }
        if (contactObject.phoneWork) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'phoneWork', contactObject.phoneWork);
        }
        if (contactObject.phoneDirect) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'phoneDirect', contactObject.phoneDirect);
        }
        if (contactObject.phoneMobile) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'phoneMobile', contactObject.phoneMobile);
        }
        if (contactObject.fax) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'fax', contactObject.fax);
        }
        if (contactObject.other) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'other', contactObject.other);
        }
        if (contactObject.note) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', contactObject.note);
        }
        if (contactObject.CustomField) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'CustomField', contactObject.CustomField);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        //          #console.log xmlReq
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

    };
  });

}).call(this);
